# 客户和订单

Goods 中有客户/订单系统如下：

```sql
create table customers
(
    id           serial primary key,
    company_name varchar(256),
    address      varchar(1024),
    city         varchar(256),
    state        varchar(256)
);

create table products
(
    id          serial primary key,
    description varchar(1024),
    unit_price  decimal(12, 4)
);

create table orders
(
    id          serial primary key,
    product_id  integer references products (id),
    order_date  timestamp,
    quantity    integer,
    customer_id integer references customers(id)
);

```

我们希望这个数据库能够允许每个订单包含多种商品，那么应该如何改造？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

* 添加一个 order_detail 表，引用 order id、product id，增加 quantity 列
* order 表中删除 product id 和 quantity 列

## 选项

### A

将 order 表的修改为以 product id 和 customer id 作为联合主键

### B

删除 orders 表中的 product id 和 quantity 列

### C

在 order 表的主键上加唯一约束